<?php
date_default_timezone_set('Asia/Jakarta');
require_once 'database/koneksi.php';

// --- CONFIG ---
$token_bukaolshop = "YXZBNVpTckVuNk9TRHlDclppV0IyT0ljQlI4NXNUbnYrK0JNWTZSdWh1ZUFBRFJFWTdGWlBVa0ozTm5rd25TR3FEakxMbHQ0Y0VITG5kcG9ENlZGQUoySUtMR3ZxNWg5cjAwSitiS2J0US9hRTNBUVQ5UjRjTDY3bFJXa2ZFMDN1RE94bGdOQ01QVHEwK21tZTR3K3VzZUU0SVlHL2Evam9FTzMzMTNkWDJkdVlsNHNqWjZ5ZEtIUUpDaGZKWElV"; 
$bot_token        = "8270160709:AAFY-hLTVMRPOw4H2b1Eb7gUwZGvq1rgsrQ";

// Menerima input dari Telegram (Webhook)
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (isset($update['callback_query'])) {
    $callback_query = $update['callback_query'];
    $callback_data  = $callback_query['data']; 
    $chat_id        = $callback_query['message']['chat']['id'];
    $message_id     = $callback_query['message']['message_id'];
    $callback_id    = $callback_query['id'];

    // Pecah data: approve_123 atau reject_123
    $explode = explode('_', $callback_data);
    $action  = $explode[0];
    $id_db   = $explode[1];

    // Ambil data transaksi dari database internal
    $query = mysqli_query($conn, "SELECT * FROM konfirmasi_pembayaran WHERE id = '$id_db' LIMIT 1");
    $data_trx = mysqli_fetch_assoc($query);

    if (!$data_trx) {
        answerCallback($bot_token, $callback_id, "Data transaksi tidak ditemukan di database!");
        exit;
    }

    // CEK STATUS: Jika sudah bukan pending, jangan diproses lagi
    if ($data_trx['status'] !== 'Pending') {
        answerCallback($bot_token, $callback_id, "Transaksi ini sudah diproses (Status: " . $data_trx['status'] . ")");
        exit;
    }

    if ($action == 'approve') {
        // Ambil nominal dan bersihkan dari titik/karakter non-angka
        $nominal_input = preg_replace("/[^0-9]/", "", $data_trx['nominal']);

        // --- PROSES API BUKAOLSHOP ---
        $header = array("Authorization: Bearer " . $token_bukaolshop);
        $post_body = array(
            "email_user"       => $data_trx['email_user'],
            "tipe"             => "tambah",
            "jumlah"           => (int)$nominal_input,
            "notifikasi"       => "true",
            "catatan_saldo"    => "Topup Berhasil - Ref ID #" . $id_db,
            "judul_notifikasi" => "Topup Berhasil!",
            "pesan_notifikasi" => "Hai " . $data_trx['nama_user'] . ", saldo sebesar Rp " . $data_trx['nominal'] . " telah berhasil ditambahkan ke akun Anda. Terima kasih!"
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://bukaolshop.net/api/v1/member/saldo");
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_body);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $res = json_decode($response, true);

        // CEK RESPON SUKSES SESUAI CONTOH ANDA
        if (isset($res['code']) && $res['code'] == 200) {
            // 1. Update status di database internal
            mysqli_query($conn, "UPDATE konfirmasi_pembayaran SET status = 'Diterima' WHERE id = '$id_db'");

            // 2. Beri pesan sukses ke admin (Edit pesan di Telegram)
            $text_admin = "✅ <b>PEMBAYARAN DITERIMA</b>\n\n";
            $text_admin .= "👤 Nama: " . $res['nama_user'] . "\n";
            $text_admin .= "💰 Saldo Masuk: Rp " . number_format($res['jumlah'], 0, ',', '.') . "\n";
            $text_admin .= "🆔 ID Perubahan: " . $res['id_perubahan'] . "\n";
            $text_admin .= "⏰ Waktu: " . date('d/m/Y H:i');
            
            editMessage($bot_token, $chat_id, $message_id, $text_admin);
            answerCallback($bot_token, $callback_id, "Saldo berhasil ditambahkan!");
        } else {
            // Jika API gagal (misal email tidak terdaftar)
            $pesan_error = isset($res['status']) ? $res['status'] : "Gagal menghubungi API BukaOlshop";
            answerCallback($bot_token, $callback_id, "ERROR: " . $pesan_error);
        }

    } else if ($action == 'reject') {
        // Proses Tolak
        mysqli_query($conn, "UPDATE konfirmasi_pembayaran SET status = 'Ditolak' WHERE id = '$id_db'");
        
        $text_reject = "❌ <b>PEMBAYARAN DITOLAK</b>\n\n";
        $text_reject .= "👤 User: " . $data_trx['nama_user'] . "\n";
        $text_reject .= "📅 Tanggal: " . date('d/m/Y H:i');
        
        editMessage($bot_token, $chat_id, $message_id, $text_reject);
        answerCallback($bot_token, $callback_id, "Konfirmasi telah ditolak.");
    }
}

// --- FUNGSI HELPER ---

function editMessage($token, $chat_id, $message_id, $text) {
    $url = "https://api.telegram.org/bot$token/editMessageCaption";
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'caption' => $text,
        'parse_mode' => 'HTML'
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function answerCallback($token, $callback_id, $text) {
    $url = "https://api.telegram.org/bot$token/answerCallbackQuery";
    $data = [
        'callback_query_id' => $callback_id,
        'text' => $text,
        'show_alert' => false
    ];
    file_get_contents($url . "?" . http_build_query($data));
}
